<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Billpayments;

/**
 * BillpaymentsSearch represents the model behind the search form of `app\models\Billpayments`.
 */
class BillpaymentsSearch extends Billpayments
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'billId', 'userId', 'accountId', 'company'], 'integer'],
            [['date', 'checkNo'], 'safe'],
            [['amount'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Billpayments::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'billId' => $this->billId,
            'date' => $this->date,
            'userId' => $this->userId,
            'accountId' => $this->accountId,
            'amount' => $this->amount,
            'company' => $this->company,
        ]);

        $query->andFilterWhere(['like', 'checkNo', $this->checkNo]);

        return $dataProvider;
    }
}
