<?php

namespace app\models;

use Yii;
use app\models\Billpayments;
use app\models\Bills;
use app\models\Invoices;
use app\models\Invopayments;

/**
 * This is the model class for table "accounts".
 *
 * @property int $id
 * @property string $name
 * @property int $currency
 * @property string $openBalance
 * @property string $number
 * @property string $date
 * @property int $type
 * @property int $company
 *
 * @property Accountstype $type0
 * @property Billpayments[] $billpayments
 * @property Bills[] $bills
 * @property Invoices[] $invoices
 * @property Invopayments[] $invopayments
 */
class Accounts extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'accounts';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'openBalance', 'number', 'date', 'type'], 'required'],
            [['type', 'company'], 'integer'],
            [['openBalance'], 'number'],
            [['date'], 'safe'],
            [['name', 'number','tin','vrn'], 'string', 'max' => 45],
            [['type'], 'exist', 'skipOnError' => true, 'targetClass' => Accountstype::className(), 'targetAttribute' => ['type' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Acc name',
            'openBalance' => 'Opening Balance',
            'number' => 'Acc #',
            'date' => 'Date',
            'type' => 'Acc group',
            'company' => 'Company',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getType0()
    {
        return $this->hasOne(Accountstype::className(), ['id' => 'type']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillpayments()
    {
        return $this->hasMany(Billpayments::className(), ['accountId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBills()
    {
        return $this->hasMany(Bills::className(), ['billby' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvoices()
    {
        return $this->hasMany(Invoices::className(), ['accId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvopayments()
    {
        return $this->hasMany(Invopayments::className(), ['acId' => 'id']);
    }
    
    public function getAccountsByType($id){
        $ret=Accounts::find()
        ->where(['type'=>$id])
        ->all();
        
        return $ret;
    }
    
    public function getAccountsByCategory($id){
        
        $cateAcc=Accountstype::find()->where(['category'=>$id])->all();
        $ret=null;
        
        if ($cateAcc != null){
            foreach ($cateAcc as $cat){
                        $ret[]= $cat->id;    
            }
        }
        
        return $ret;
    }
    
    public function getCurrency($cr){
        if ($cr==1) return 'Tsh';
        elseif ($cr==2) return 'Usd';
    }  
    
    public function getWorkshopPurchaseAccounts(){
        $ret=null;
        
        $accounts = Accounts::find()
        ->where(['like', 'name', 'spare']) 
        ->all();
        
        if ($accounts != null){
            foreach ($accounts as $account){
             $ret=$account->id;   break; 
              
            }
        }
        
        return $ret;
    }
}
