<?php

namespace app\controllers;

use Yii;
use app\models\Invcontent;
use app\models\Invopayments;
use app\models\InvopaymentsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Invoices;

/**
 * InvopaymentsController implements the CRUD actions for Invopayments model.
 */
class InvopaymentsController extends Controller
{
    public function init() {
        $this->layout = 'accounts';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Invopayments models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new InvopaymentsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Invopayments model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Invopayments model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Invopayments();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->invId=$id;
            $model->date=date('Y-m-d');
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            
            if ($model->amount<=(Invcontent::getInvoiceCost($id)-Invopayments::getInvoicePaidAmount($id)) && $model->amount>0){
                if($model->save()){
                    if((Invcontent::getInvoiceCost($id)-Invopayments::getInvoicePaidAmount($id))==0){
                    $invoice=Invoices::findOne($id);
                    $invoice->paid=1;
                    $invoice->save();
                    }
                        return $this->redirect(['invoices/index']);
                        }
              }else{
                    \Yii::$app->session->setFlash('error','Error on the amount paid,it exceed the invoice balance or you have entered a negative amount');
            }
        }

        return $this->render('create', [
            'model' => $model,'id'=>$id,
        ]);
    }

    /**
     * Updates an existing Invopayments model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Invopayments model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Invopayments model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Invopayments the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Invopayments::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
