<?php

namespace app\controllers;

use Yii;
use app\models\Billcontent;
use app\models\Cfbills;
use app\models\Invcontent;
use app\models\InvcontentSearch;
use app\models\Invoices;
use app\models\Packages;
use app\models\Servicecost;
use app\models\Services;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use kartik\mpdf\Pdf;
use yii\data\ActiveDataProvider;

/**
 * InvcontentController implements the CRUD actions for Invcontent model.
 */
class InvcontentController extends Controller
{
    public function init() {
        $this->layout = 'accounts';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Invcontent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new InvcontentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Invcontent model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Invcontent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $fileId= Invoices::findOne($id)->fileId;
        if ($fileId != 0) $this->layout='cnf';
        
        $query = Invcontent::find();
        $query->andFilterWhere([
            'invId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $model = new Invcontent();

        if ($model->load(Yii::$app->request->post()) and $fileId==0) {
            
            $model->invId=$id;
            $model->date=date('Y-m-d');
            $contId=Invcontent::checkServiceInInvoice($model->serviceId,$id);
            
            if ($contId==null and $model->amount>=Servicecost::getServiceCost($model->serviceId)->saleamount){
            if ($model->save()){
            return $this->redirect(['create', 'id' => $id]);
            }
            }else{
                return $this->redirect(['update', 'id' => $contId]);
            }
        }elseif(isset($_POST['Invcontent'])){
            $bills= Cfbills::find()->where(['fileId'=>$fileId])->all();
            $cnt=1;
            if ($bills != null){
                foreach ($bills as $bill){
                    $billcontents=Billcontent::find()->where(['billId'=>$bill->billId])->all();
                    
                    if ($billcontents != null){
                        foreach ($billcontents as $i=>$content){
                            $savemodel=new Invcontent();
                            if(isset($_POST['Invcontent'][$i]['serviceId'])){
                                $savemodel->invId=$id;
                                $savemodel->date=date('Y-m-d');
                                $savemodel->count=1;
                                $savemodel->amount=$_POST['Invcontent'][$i]['amount'];
                                $savemodel->serviceId=$_POST['Invcontent'][$i]['serviceId'];
                                if (Servicecost::getServiceCost($savemodel->serviceId)->saleamount != 0) $savemodel->save();
                                $cnt++;
                            }
                        }
                    }
                }
            }
            
            $agencyfee=Services::getServiceByName('Agency fee');
            $dropoff20=Services::getServiceByName('Drop off cost 20ft');
            $quantity20=Packages::getQuantityByType(2);
            $dropoff40=Services::getServiceByName('Drop off cost 40ft');
            $quantity40=Packages::getQuantityByType(4);
            $transcost=Services::getServiceByName('Transportation cost');
            
            if ($agencyfee != null){
                $cnt++;
                if(isset($_POST['Invcontent'][$cnt]['serviceId'])){
                    $savemodel->invId=$id;
                    $savemodel->date=date('Y-m-d');
                    $savemodel->count=1;
                    $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                    $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                    if (Servicecost::getServiceCost($savemodel->serviceId)->saleamount != 0) $savemodel->save();
                   
                }
            }
            
            if ($dropoff20 != null and $quantity20>0){
                $cnt++;
                if(isset($_POST['Invcontent'][$cnt]['serviceId'])){
                    $savemodel->invId=$id;
                    $savemodel->date=date('Y-m-d');
                    $savemodel->count=$quantity20;
                    $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                    $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                    if (Servicecost::getServiceCost($savemodel->serviceId)->saleamount != 0) $savemodel->save();
                   
                }
            }
            
            if ($dropoff40 != null and $quantity40>0){
                $cnt++;
                if(isset($_POST['Invcontent'][$cnt]['serviceId'])){
                    $savemodel->invId=$id;
                    $savemodel->date=date('Y-m-d');
                    $savemodel->count=$quantity40;
                    $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                    $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                    if (Servicecost::getServiceCost($savemodel->serviceId)->saleamount != 0) $savemodel->save();
                    
                }
            }
            
            if ($transcost != null and ($quantity40+$quantity20)>0){
                $cnt++;
                if(isset($_POST['Invcontent'][$cnt]['serviceId'])){
                    $savemodel->invId=$id;
                    $savemodel->date=date('Y-m-d');
                    $savemodel->count=$quantity40+$quantity20;
                    $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                    $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                    if (Servicecost::getServiceCost($savemodel->serviceId)->saleamount != 0) $savemodel->save();
                    
                }
            }
            
            return $this->redirect(['create', 'id' => $id]);
        }

        return $this->render('create', [
            'model' => $model,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }

    /**
     * Updates an existing Invcontent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            
            if ($model->amount>=Servicecost::getServiceCost($model->serviceId)->saleamount){
                if ($model->save()){
                return $this->redirect(['create', 'id' => $model->invId]);
                }
            }else{
                \Yii::$app->session->setFlash('error','Sales price is lower than margin price');
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Invcontent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $content=$this->findModel($id);
        $invId=$content->invId;
        $content->delete();

        return $this->redirect(['create','id'=>$invId]);
    }

    /**
     * Finds the Invcontent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Invcontent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Invcontent::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionPrintinvoice($id) {
        
        $model= Invoices::findOne($id);
        $contents=Invcontent::find()->where(['invId'=>$id])->all();
        $data = $this->renderPartial('_invoiceview',['model'=>$model,'contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Invoice'],
            'methods' => [
               'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    
    public function actionCostcreate() {
        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $cat_id = $_POST['depdrop_parents'];
                $out =[['id'=>Servicecost::getServiceCost($cat_id)->saleamount, 'name'=>number_format(Servicecost::getServiceCost($cat_id)->saleamount)]];
                return ['output'=>$out, 'selected'=>''];
            }
        }
        return ['output'=>'', 'selected'=>''];
    }
    
    
    public function actionGetPrice($selected)
    {
        $service= Servicecost::find()->where(['serviceId'=>$selected,'status'=>1])->one();
        
        echo json_encode($service->saleamount);
    }
    
}
