<?php

namespace app\controllers;

use Yii;
use app\models\Cars;
use app\models\Cartype;
use app\models\Fuelrequest;
use app\models\FuelrequestSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;
use app\models\Movements;

/**
 * FuelrequestController implements the CRUD actions for Fuelrequest model.
 */
class FuelrequestController extends Controller
{
    public function init() {
        $this->layout = 'operations';
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Fuelrequest models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FuelrequestSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Fuelrequest model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Fuelrequest model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Fuelrequest();

        if ($model->load(Yii::$app->request->post())) {
        
            $model->fueldate=date('Y-m-d',strtotime($model->fueldate));
            $model->recorddate=date('Y-m-d');
            $model->truckId=$id; 
            $model->byy= \Yii::$app->user->getId();
            
            if (Fuelrequest::checkDublicate($model->truckId,$model->fueldate,$model->volume)){
                if (Fuelrequest::countTruckActiveFuel($model->truckId)<2){
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new fuel request');
                return $this->redirect(['create', 'id' => $id]);
            }
            
                }else{
                    \Yii::$app->session->setFlash('error','Too many active fuels to request another one');
                    return $this->redirect(['create', 'id' => $id]);
                }
            
            }else {
                \Yii::$app->session->setFlash('error','Dublicate request');
                return $this->redirect(['create', 'id' => $id]);
            }
           
           
        }

        return $this->render('create', [
            'model' => $model,'truckId'=>$id,
        ]);
    }
    
    
    public function actionCarselect()
    {
        $model = new Fuelrequest();
        
        if ($model->load(Yii::$app->request->post())) {
            return $this->redirect(['create','id'=>$_POST['Fuelrequest']['truckId']]);
        }
        
        return $this->render('carselect', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Fuelrequest model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        

        if ($model->load(Yii::$app->request->post())) {
            $model->recorddate=date('Y-m-d');
            $model->byy= \Yii::$app->user->getId();
            $model->fueldate=date('Y-m-d',strtotime($model->fueldate));
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new fuel request');
            return $this->redirect(['create', 'id' => $model->truckId]);
            }
        }

        $model->fueldate=date('d-M-Y',strtotime($model->fueldate));
        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Fuelrequest model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Fuelrequest model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Fuelrequest the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Fuelrequest::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionDeactivatefuel($id){
        $fuel=Fuelrequest::findOne($id);
        $fuel->status=0;
        $fuel->save();
        
        return $this->redirect(['create', 'id' => $fuel->truckId]);
    }
    
    public function actionReport()
    {
        $this->layout='main';
        $model = new Fuelrequest();
        
        if (isset($_POST['Fuelrequest'])) {
            
            if($_POST['Fuelrequest']['to'] > $_POST['Fuelrequest']['from']){
                $f=date('Y-m-d',strtotime($_POST['Fuelrequest']['from']));
                $t=date('Y-m-d',strtotime($_POST['Fuelrequest']['to']));
                $trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all();
                $fuelaverage=array();
                $fuelrecords=array();
                $summary=array();
                $cnt=0;
                $totalfilled=0;
                $totaltrips=0;
                $totalcost=0;
                
                if ($trucks != null){
                    foreach ($trucks as $truck){
                        $fuelrecords[$cnt]['car']=$truck->plateno;
                        $fuelrecords[$cnt]['twenty']=Movements::carAmountOfLoadBySizeTime($truck->plateno,$f,$t,2);
                        $fuelrecords[$cnt]['forty']=Movements::carAmountOfLoadBySizeTime($truck->plateno,$f,$t,4);
                        $fuelrecords[$cnt]['other']=Movements::carAmountOfLoadBySizeTime($truck->plateno,$f,$t,0);
                        $fuelrecords[$cnt]['trips']=Movements::carMovementsByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['volume']=Fuelrequest::getTruckFueledAmountByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['spent']=Fuelrequest::getTruckConsumedfuelByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['onhand']= $fuelrecords[$cnt]['volume']-$fuelrecords[$cnt]['spent'];
                        $fuelrecords[$cnt]['ld']= Fuelrequest::getTruckLastFueledDate($truck->plateno);
                        $fuelrecords[$cnt]['cost']=Fuelrequest::getTruckConsumedfuelByTimeCost($truck->plateno,$f,$t);
                        
                        $fuelaverage[$cnt]['av']=Fuelrequest::getTruckConsumedfuelByTimeCost($truck->plateno,$f,$t);
                       
                        
                        $totalfilled=$totalfilled+$fuelrecords[$cnt]['volume'];
                        $totaltrips=$totaltrips+ $fuelrecords[$cnt]['trips'];
                        $totalcost=$totalcost+$fuelrecords[$cnt]['cost'];
                        
                        $cnt++;
                        
                    }
                    
                    if ($fuelaverage !=null and $fuelrecords != null) array_multisort($fuelaverage,SORT_DESC,$fuelrecords);
                    $summary['trucks']=count($trucks); $summary['totalfilled']=$totalfilled; $summary['totaltrips']=$totaltrips; $summary['totalcost']=$totalcost;
                }
                
                $data = $this->renderPartial('_reportview',['datas'=>$fuelrecords,'from'=>$_POST['Fuelrequest']['from'],'to'=>$_POST['Fuelrequest']['to'],'summary'=>$summary]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'Fuel report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
                
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('report', [
            'model' => $model,
        ]);
    }
}
