<?php

namespace app\controllers;

use Yii;
use app\models\Cardrivers;
use app\models\CardriversSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Trailers;
use app\models\Movements;
use app\models\Uzers;

/**
 * CardriversController implements the CRUD actions for Cardrivers model.
 */
class CardriversController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Cardrivers models.
     * @return mixed
     */
    public function actionIndex()
    {
        $this->layout='operations';
        $drivers= Cardrivers::find()
        ->where(['status'=>1])->all();
        
        $allDrivers=null;
        $average=null;
        $cnt=0;
        
        if($drivers!=null){
            foreach ($drivers as $driver){
                $allDrivers[$cnt]['name']=$driver->user->firstname.' '.$driver->user->lastname;
                $allDrivers[$cnt]['phone']=$driver->user->mobilephone;
                $allDrivers[$cnt]['moves']=Cardrivers::getDriverStrength($driver->userId);
                $allDrivers[$cnt]['bday']=Uzers::getAgeByBdate($driver->user->birthdate);
                $allDrivers[$cnt]['licence']=$driver->user->licence;
                
                $average[$cnt]['val']=$allDrivers[$cnt]['moves'];
                $cnt++;
            }
        }
        
        array_multisort($average,SORT_DESC,$allDrivers);
        
        return $this->render('index',['drivers'=>$allDrivers]);
    }

    /**
     * Displays a single Cardrivers model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Cardrivers model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Cardrivers(); 
        $trailer= new Trailers();

        if ($model->load(Yii::$app->request->post()) && $trailer->load(\Yii::$app->request->post())) {
         
            $model->carId=$id;
            $model->dateassigned=date('Y-m-d');
            
            $trailer->horseid=$id;
            $trailer->dateassigned=date('Y-m-d');
            
            $valid=$model->validate();
            $valid=$valid && $trailer->validate();
            $valid=$valid;
      
            if($valid){
                Cardrivers::deactivateActiveDriver($id,$model->userId);
                Trailers::deactivateActiveTrailer($id,$trailer->trailerid);
              $model->save();
              $trailer->save(); 
            \Yii::$app->session->setFlash('success','Successfull set a trailer and a driver');
            return $this->redirect(['cars/view', 'id' => $id]);
            
            }else {
                \Yii::$app->session->setFlash('error','Driver & Trailer setup failed');
            }
            
        }

        return $this->renderAjax('create', [
            'model' => $model,'trailer'=>$trailer,'id'=>$id,
        ]);
    }

    /**
     * Updates an existing Cardrivers model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Cardrivers model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Cardrivers model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Cardrivers the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Cardrivers::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
