<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\RfqSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All request for quotations';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="rfq-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('New Rfq', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            [
                'attribute'=>'billby',
                'value'=>function ($model, $key, $index, $widget) {return $model->billby0->name; }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],
            [
                'attribute'=>'dueDate',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->dueDate)); }
            ],
           
            //'paid',
            //'company',
            //'currency',
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['rfqcontent/create','id'=>$model->id],['class' => 'glyphicon glyphicon-tasks','alt'=>'create']);
                },
                ],
                
                [
                    'label'=>' ',
                    'format' => 'raw',
                    'value'=>function ($model, $key, $index, $widget) {
                    return Html::a('',['rfqcontent/printrequest','id'=>$model->id],['class' => 'glyphicon glyphicon-download-alt']);
                    },
                    ],

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],
            
            
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>

</div>
