<?php

use app\models\Accounts;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Rfq */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $liaAccounts = ArrayHelper:: map (Accounts::find()->where(['type'=>Accounts::getAccountsByCategory([5,4])])->all() , 'id' , function($model, $defaultValue){ return $model->name; }); ?>


<div class="rfq-form">

    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
    <table width="100%">
<tr>
        <td>
        
         <?php 

echo $form->field($model, 'billby')->widget(Select2::classname(), [
    'data' => $liaAccounts,
    'language' => 'en',
    'options' => ['placeholder' => 'Billing acc...'],
    'pluginOptions' => [
        'allowClear' => true,
        'tabindex' => false,
    ],
]);

?>
    </td>
    
 <td>
<?php 
echo DatePicker::widget([
    'model' => $model,
    'attribute' => 'date',
    'options' => ['placeholder' => 'Bill date'],
    'pluginOptions' => [
        'format' => 'dd-M-yyyy',
        'todayHighlight' => true
    ]
]);

?>
</td>

<td>&nbsp;</td>

      <td>
<?php 
echo DatePicker::widget([
    'model' => $model,
    'attribute' => 'dueDate',
    'options' => ['placeholder' => 'Due date'],
    'pluginOptions' => [
        'format' => 'dd-M-yyyy',
        'todayHighlight' => true
    ]
]);

?>
</td>  

<td>&nbsp;</td>

 <td> <?= $form->field($model, 'currency')->dropdownList([
        1 => 'Tsh', 
        2 => 'Usd',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>
  
  </tr>
  
  <tr>
  
  <td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
    </td>
    
    <td></td><td></td><td></td><td></td><td></td>
    </tr></table>

    <?php ActiveForm::end(); ?>

</div>
