<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Tireallocation;
use app\models\Tirestore;

/* @var $this yii\web\View */
/* @var $searchModel app\models\TirestoreSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Tire store';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tirestore-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
         <?= Html::button('New stock',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
    </p>
    
    
     <?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>
    
    

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'regnumber',
            [
                'attribute'=>'expdate',
                'value'=>function ($model, $key, $index, $widget) {return date('d-M-Y',strtotime($model->expdate)); }
            ],
            [
                'attribute'=>'type',
                'value'=>function ($model, $key, $index, $widget) {return Tirestore::getTireType($model->type); }
            ],
            [
                'attribute'=>'quantity',
                'value'=>function ($model, $key, $index, $widget) {return $model->quantity-Tireallocation::getStoreAllocatedTires($model->id); }
            ],

            [
                'class' => 'yii\grid\ActionColumn',
                'template'=>'{update}',
            ],
        ],
    ]); ?>
</div>
