// moment.js language configuration

// language : romanian (ro)

// author : Vlad Gurdiga : https://github.com/gurdiga

// author : Valentin Agachi : https://github.com/avaly



(function (factory) {

    if (typeof define === 'function' && define.amd) {

        define(['moment'], factory); // AMD

    } else if (typeof exports === 'object') {

        module.exports = factory(require('../moment')); // Node

    } else {

        factory(window.moment); // Browser global

    }

}(function (moment) {

    function relativeTimeWithPlural(number, withoutSuffix, key) {

        var format = {

            'mm': 'minute',

            'hh': 'ore',

            'dd': 'zile',

            'MM': 'luni',

            'yy': 'ani'

        },

            separator = ' ';

        if (number % 100 >= 20 || (number >= 100 && number % 100 === 0)) {

            separator = ' de ';

        }



        return number + separator + format[key];

    }



    return moment.lang('ro', {

        months : "ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie".split("_"),

        monthsShort : "ian_feb_mar_apr_mai_iun_iul_aug_sep_oct_noi_dec".split("_"),

        weekdays : "duminică_luni_marți_miercuri_joi_vineri_sâmbătă".split("_"),

        weekdaysShort : "Dum_Lun_Mar_Mie_Joi_Vin_Sâm".split("_"),

        weekdaysMin : "Du_Lu_Ma_Mi_Jo_Vi_Sâ".split("_"),

        longDateFormat : {

            LT : "H:mm",

            L : "DD.MM.YYYY",

            LL : "D MMMM YYYY",

            LLL : "D MMMM YYYY H:mm",

            LLLL : "dddd, D MMMM YYYY H:mm"

        },

        calendar : {

            sameDay: "[azi la] LT",

            nextDay: '[mâine la] LT',

            nextWeek: 'dddd [la] LT',

            lastDay: '[ieri la] LT',

            lastWeek: '[fosta] dddd [la] LT',

            sameElse: 'L'

        },

        relativeTime : {

            future : "peste %s",

            past : "%s în urmă",

            s : "câteva secunde",

            m : "un minut",

            mm : relativeTimeWithPlural,

            h : "o oră",

            hh : relativeTimeWithPlural,

            d : "o zi",

            dd : relativeTimeWithPlural,

            M : "o lună",

            MM : relativeTimeWithPlural,

            y : "un an",

            yy : relativeTimeWithPlural

        },

        week : {

            dow : 1, // Monday is the first day of the week.

            doy : 7  // The week that contains Jan 1st is the first week of the year.

        }

    });

}));

